///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI TCPThreadFunction(LPVOID pvThread)
{
	Client* pClient = (Client*) pvThread;  //typecast

	pClient->TimeOut.tv_sec	= 5;
	pClient->TimeOut.tv_usec = 250;

	FD_ZERO(&pClient->ReadFDS);
	FD_ZERO(&pClient->WriteFDS);
	FD_ZERO(&pClient->ExceptFDS);

	while(1)
	{
        if(pClient->Connected)
        {
    		// Set all connected clients to Read, Write, Except
   			if( pClient->Connected == true)
   			{
   				FD_SET(pClient->Socket, &pClient->ReadFDS);
   				FD_SET(pClient->Socket, &pClient->WriteFDS);
   				FD_SET(pClient->Socket, &pClient->ExceptFDS);
   			}

    		// Socket Select...
    		if(select(-1, &pClient->ReadFDS, &pClient->WriteFDS, &pClient->ExceptFDS, &pClient->TimeOut) == SOCKET_ERROR)
    		{
    			// TCPThreadFunction- Socket error.
    			return -1;
    		}

    		// Are any clients ready to send or receive data? If so send/receive their data.
			pClient->DoReceiveData();
			pClient->DoSendData();

    		// Are any clients Disconnect flag set? If so Disconnect that client.
			if( pClient->Disconnect == true)
                pClient->DisconnectClient();
        }
    	Sleep(glTCPLoopDelay);
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::CreateNewTCPThread(void)
{
    TCPThreadHandle = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)TCPThreadFunction, (LPVOID) this, 0, (LPDWORD) &TCPThreadID);

    if(TCPThreadHandle == NULL)
        return false;

    TCPThreadActive = true;
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::SuspendTCPThread(void)
{
	TCPThreadActive = false;
	return(-1 != SuspendThread(TCPThreadHandle));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::KillTCPThread(void)
{
	return(-1 != TerminateThread(TCPThreadHandle, 1));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::ResumeTCPThread(void)
{
	TCPThreadActive = true;
	return(-1 != ResumeThread(TCPThreadHandle)); 
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Client::IsTCPThreadActive(void)
{
	return TCPThreadActive;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
